/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.arcslogs;

import com.ibm.hwmca.base.arcslogs.ArcCopyDataException;
import com.ibm.hwmca.base.arcslogs.ArcErrorIds;
import com.ibm.hwmca.base.arcslogs.ArcMediaInUseException;
import com.ibm.hwmca.base.arcslogs.ArcMediaLabelException;
import com.ibm.hwmca.base.arcslogs.ArcMediaNotReadyException;
import com.ibm.hwmca.base.arcslogs.ArcMediaWriteProtectedException;
import com.ibm.hwmca.base.arcslogs.ArcNoSpaceException;
import com.ibm.hwmca.base.arcslogs.ArcRetrieveDataException;
import com.ibm.hwmca.base.arcslogs.ArchSecLogsBean;
import com.ibm.hwmca.base.arcslogs.WriteData;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class ArcSLogsTasklet
extends PanelTasklet
implements ArcErrorIds {
    private static final String TRACE_MASKT = "XARCTSKT";
    private static final String TRACE_MASKF = "XARCTSKF";
    private static final String TRACE_MASKD = "XARCTSKD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-28, "ArcE4Tasklet");
    private static final String AUIML = "com.ibm.hwmca.base.arcslogs.res.ArchiveSecurityLogsRes";
    private static final String PANEL = "HMCArchiveSecurityLogsPanel";
    private ArchSecLogsBean bean;
    private static final String BUSY_TITLE = "arc.busy.title";
    private static final String TASK_TITLE = "arc.task.title";
    private static final String TASK_SUCCESS = "arc.task.succ";
    private static final String BUSY_SEND_TEXT = "arc.busy_send.text";
    public static final String BUNDLE_NAME = "com/ibm/hwmca/base/arcslogs/res/message";
    ObjectId[] ids = null;

    public ArcSLogsTasklet() {
        Trace.trace(TRACE_MASKT, "<-> ArcSLogsTasklet() constructor");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "--> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 5, throwable).log();
        Trace.trace(TRACE_MASKT, "<-- logException()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block18: {
            Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
            boolean busyDialogVisible = false;
            Object targets = null;
            boolean numberOfTargets = false;
            try {
                if (request.isInitialRequest()) {
                    this.bean = new ArchSecLogsBean(HMC.getHMC().getUIInfo().getTitle());
                    response.openModalChild(AUIML, PANEL, this.bean);
                    break block18;
                }
                if (request.isDisposed() || request.isCanceled()) {
                    Trace.trace(TRACE_MASKF, "action = dispose or cancel");
                    response.terminate();
                    break block18;
                }
                String action = (String)request.getData("event");
                Trace.trace(TRACE_MASKF, "action = " + action);
                if (action.equals("CANCEL")) {
                    response.terminate();
                    break block18;
                }
                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), BUSY_TITLE), new LocalizableText(BaseTextBundle.getBundleName(), BUSY_SEND_TEXT));
                busyDialogVisible = true;
                try {
                    WriteData write = new WriteData();
                    write.prepareMedia(3);
                    write.write();
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCDSKOK"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    new E4EventLog(new LocalizableText(BaseTextBundle.getBundleName(), TASK_SUCCESS), "ARCSECLOG").log();
                }
                catch (ArcMediaNotReadyException e) {
                    Trace.trace(TRACE_MASKF, "DVD not ready exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCDVDRY"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcMediaWriteProtectedException e) {
                    Trace.trace(TRACE_MASKF, "DVD write protect exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCDVDPR"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcRetrieveDataException e) {
                    Trace.trace(TRACE_MASKF, "Retrieve data exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCERR02"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcCopyDataException e) {
                    Trace.trace(TRACE_MASKF, "Diskette copy exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCERR03"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcNoSpaceException e) {
                    Trace.trace(TRACE_MASKF, "Not enough space exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCSPACE"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcMediaInUseException e) {
                    Trace.trace(TRACE_MASKF, "Media in use exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCINUSE"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (ArcMediaLabelException e) {
                    Trace.trace(TRACE_MASKF, "Media label exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCLABEL"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "Internal error exception");
                    busyDialogVisible = false;
                    this.destroyBusyDialog();
                    new FrameworkLog(logInfo, 7).log();
                    this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TASK_TITLE), new BaseMessageText("ARCERR01"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                }
                response.terminate();
            }
            catch (Exception e) {
                TaskletException texc = new TaskletException(e);
                new FrameworkLog(logInfo, 4, texc).log();
                throw texc;
            }
            finally {
                if (busyDialogVisible) {
                    this.destroyBusyDialog();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<-- service()");
    }
}

